import sys
import logging
import statistics
from datetime import datetime

def extract_fields(text, separator, field_numbers, transform=None):
    text = text.strip()
    data = []
    for n, line in enumerate(text.split('\n')):
        parts = line.split(separator)
        try:
            d = [parts[i] for i in field_numbers]
            if transform:
                d = transform(*d)
            data.append(d)
        except:
            logging.exception(f"Can't parse line {n}. Skipping it.")
    return data

def chunklist(d, num_els):
    newd = []
    for i in range(len(d) // num_els):
        newd.append(d[i*num_els:(i*num_els)+num_els])
    if (len(d) % num_els) != 0:
        newd.append(d[-(len(d) % num_els):])
    return newd

def compute_chunk_averages(d, num_els):
    chunks = chunklist(d, num_els)
    newd = []
    for chunk in chunks:
        chunkdate = chunk[0][0]
        chunkavgprice = statistics.mean([x[1] for x in chunk])
        chunkavgtotalret = statistics.mean([x[2] for x in chunk])
        newd.append([chunkdate, chunkavgprice, chunkavgtotalret])
    return newd

def main():
    transform = lambda a, b, c: [datetime(*[int(p) for p in a.split('.')][::-1]).date(), float(b), float(c)]
    data = extract_fields(sys.stdin.read(), ';', [0, 5, 6], transform)
    data = sorted(data, key=lambda x: x[0])
    # fix data: align total return to initial price
    offset_initial_total_return = data[0][2] - data[0][1]
    data = [[d, p, tr-offset_initial_total_return] for d, p, tr in data]
    avgs = compute_chunk_averages(data, 7)
    print([[d.strftime(r'%Y-%m-%d'), round(p, 2), round(t, 2)] for d, p, t in avgs])

if __name__ == '__main__':
    main()