from json import encoder
import sys
import json
import datetime

def get_date(s):
    return datetime.datetime.strptime(s, r'%Y-%m-%d').date()

def load_data_csv(data):
    datapoints = []
    for nline, line in enumerate(data.strip().split('\n')):
        line = line.strip()
        if not line:
            continue
        try:
            pdate, pprice = line.split(',')
            pdate_year, pdate_month = pdate.split('-')
            pdate = datetime.date(int(pdate_year), int(pdate_month), 1)
            pprice = float(pprice)
            datapoints.append((pdate, pprice))
        except Exception as e:
            print(f"Error in line {nline}: {e}")
            continue
    return sorted(datapoints, key=lambda x: x[0])

def average_loss_between(datapoints, from_date, until_date):
    started = False
    total_gain = 0.0
    num_points = 1
    for pdate, pprice in datapoints:
        if started:
            if pdate > until_date:
                break
            num_points += 1
            total_gain += pprice - from_price
        elif pdate >= from_date:
            started = True
            from_price = pprice
    if started:
        return (total_gain / num_points) / from_price
    return None

class DateEncoder(json.JSONEncoder):
    def default(self, o):
        if type(o) is datetime.date:
            return f"%s-%02d" % (o.year, o.month)
        return o

def main():
    with open(sys.argv[1]) as f:
        data = load_data_csv(f.read())
        print(f"Loaded {len(data)} datapoints.")
        for pdate, pprice in data:
            print(json.dumps(data, cls=DateEncoder))
            # print(f'[{pdate.strftime(r"%Y-%m")}, {pprice}],')
    return
    from_date = get_date(sys.argv[2])
    until_date = get_date(sys.argv[3])
    if from_date >= until_date:
        print(f"Invalid date range {from_date} -> {until_date}")
    else:
        print(average_loss_between(data, from_date, until_date))

if __name__ == '__main__':
    main()