import sys
from datetime import date

def get_date(s):
    m, y = s.split('-')
    return date(int(y), int(m), 1)

outstr = ""
latest_printed = False
latest_date = None
for line in sys.stdin:
    line = line.strip()
    d, t, val = line.split(',')
    if '-' in d:
        d = get_date(d)
        if latest_date and not latest_printed:
            print(f'{latest_date},{latest_val}')
        if latest_date and d and d.year != latest_date.year:
            print(outstr)
            outstr = ""
        latest_date = d
        latest_val = val
        latest_printed = False
    else:
        if t.upper() == 'AVG':
            outstr += (f'["{latest_date}",{val}], ')
            latest_printed = True
            continue

print(outstr)