# Compute inflation (year-over-year) from series of Consumer Price Indices (CPI)

# Takes a series of date:CPI and outputs date:Inflation where Inflation_t = (CPI_t - CPI_(t-12))
# input and output are in CSV format. Date is "YYYY-mm". Output price is in %

import csv
import sys
from datetime import datetime, date

# compute inflation year over year. Set this this 1 for monthly, 3 for quarterly
inflation_period_months = 12

def output_data(data, fobj):
    fobj.write('"Date",Inflation\n')
    for r in data:
        pdate = r[0].strftime("%Y-%m")
        pval = round(r[1], 2)
        fobj.write(f'"{pdate}",{pval}\n')

def load_data():
    cr = csv.DictReader(sys.stdin)
    return [(datetime.strptime(row['Date'], r"%Y-%m").date(), float(row['Value'])) for row in cr]
    
cpi_series = load_data()
k_minus_1_prices = cpi_series[:-1]
k_prices = cpi_series[1:]

inflation_series = []
for cpi_prev, cpi_cur in zip(cpi_series, cpi_series[inflation_period_months:]):
    # cpi points include (date, price)
    inflation = 100 * (cpi_cur[1] - cpi_prev[1]) / cpi_prev[1]
    d = cpi_cur[0]
    inflation_series.append((d, inflation))

output_data(inflation_series, sys.stdout)