# Combine CSV sequences of interest rates and inflation into:
#   month, inflation, interest_rate, inflation_less_interest

import csv
import sys

interests_fname = sys.argv[1]
inflation_fname = sys.argv[2]

def load_csv(fname, field_names, **kwargs):
    inter = dict()
    with open(fname) as f:
        csvr = csv.DictReader(f, **kwargs)
        return {r[field_names[0]]:r[field_names[1]] for r in csvr}

interests = load_csv(interests_fname, delimiter=';', field_names=['Date', 'Value'])
inflation = load_csv(inflation_fname, field_names=['Date', 'Inflation'])

result = []
for month in sorted(inflation.keys()):
    if month in interests:
        print(f'"{month}",{inflation[month]},{interests[month]},{round(float(interests[month])-float(inflation[month]), 2)}')
    else:
        print(f'"{month}",{inflation[month]},,')
