#! python3

# Output a the growth of a fund with compounding, assuming continual payment:
#   Year, costs, end_amount
#
# Where:
#   year = year number
#   costs = total money paid into fund historically, assuming fixed annual payment
#   end_amount = total money the fund is worth year-end, based on the assumed growth rate


annual_deposit = 7000
n_years = 47
inv_yield = 0.065
ter = 0.005
marginal_tax = 0.3

current_amount = 0
total_costs = 0

all_values = []
for year in range(1, n_years+1):
    end_amount = (current_amount + annual_deposit) * (1+inv_yield - ter)
    total_costs += annual_deposit * (1-marginal_tax)
    current_amount = end_amount
    all_values.append([year, total_costs, end_amount])

print(',\n'.join([f'''[{year}, {round(total_costs, 2)}, {round(end_amount, 2)}]''' for year, total_costs, end_amount in all_values]))
